package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	Maestro                     *maestro.Maestro
	PerformPlannerFormPresenter *form_presenters.PerformPlannerFormPresenter
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.SeePlannerMaeIn, out *maes.SeePlannerMaeOut) (bool, error) {
	out.Response.FormScope.Form = in.Request.Form
	out.Response.FormScope.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormScope.FormFields = this.PerformPlannerFormPresenter.Setup(&out.Response.FormScope.Form)

	return true, nil
}
