package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/see_planner"
)

type SeePlannerMae struct {
	ConfigureFormStep *steps.ConfigureFormStep
	Maestro           *maestro.Maestro
	SeeStep           *steps.SeeStep
}

func (this *SeePlannerMae) Act(ctx context.Context, in *maes.SeePlannerMaeIn) (*maes.SeePlannerMaeOut, error) {
	out := &maes.SeePlannerMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.SeePlannerMaeIn, out *maes.SeePlannerMaeOut) (bool, error){
		this.SeeStep.Act,
		this.ConfigureFormStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
