package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	Maestro                         *maestro.Maestro
	PerformRenewOrdersFormPresenter *form_presenters.PerformRenewOrdersFormPresenter
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, out *maes.SeeRenewOrdersMaeOut) (bool, error) {
	out.Response.FormScope.Form = in.Request.Form
	out.Response.FormScope.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormScope.FormFields = this.PerformRenewOrdersFormPresenter.Setup(&out.Response.FormScope.Form)

	return true, nil
}
