package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/see_renew_orders"
)

type SeeRenewOrdersMae struct {
	ConfigureFormStep *steps.ConfigureFormStep
	Maestro           *maestro.Maestro
	SeeStep           *steps.SeeStep
}

func (this *SeeRenewOrdersMae) Act(ctx context.Context, in *maes.SeeRenewOrdersMaeIn) (*maes.SeeRenewOrdersMaeOut, error) {
	out := &maes.SeeRenewOrdersMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, out *maes.SeeRenewOrdersMaeOut) (bool, error){
		this.SeeStep.Act,
		this.ConfigureFormStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
