package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type AddGardenTasksToResponseStep struct {
	GardenTaskFetcher  *fetchers.GardenTaskFetcher
	GardenTaskHydrator *hydrators.GardenTaskHydrator
	Maestro            *maestro.Maestro
}

func (this *AddGardenTasksToResponseStep) Act(ctx context.Context, in *maes.ShowGardenMaeIn, out *maes.ShowGardenMaeOut) (bool, error) {
	gardenId := in.Request.Id
	mod := this.GardenTaskFetcher.Mod()
	mod.ExactStringValueFilter("garden_id", gardenId)
	page, pagination, err := this.GardenTaskFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	out.Response.GardenTasks = page
	out.Response.GardenTasksPagination = pagination
	this.GardenTaskHydrator.ManyViaPreset(ctx, page, "list", nil)
	return true, nil
}
