package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type AddPlantationsToResponseStep struct {
	Maestro            *maestro.Maestro
	PlantationFetcher  *fetchers.PlantationFetcher
	PlantationHydrator *hydrators.PlantationHydrator
}

func (this *AddPlantationsToResponseStep) Act(ctx context.Context, in *maes.ShowGardenMaeIn, out *maes.ShowGardenMaeOut) (bool, error) {
	gardenId := in.Request.Id
	mod := this.PlantationFetcher.Mod()
	mod.ExactStringValueFilter("garden_id", gardenId)
	page, pagination, err := this.PlantationFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	out.Response.Plantations = page
	out.Response.PlantationsPagination = pagination
	this.PlantationHydrator.ManyViaPreset(ctx, page, "list", nil)
	return true, nil
}
