package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type FetchEntityStep struct {
	GardenFetcher  *fetchers.GardenFetcher
	GardenHydrator *hydrators.GardenHydrator
	Maestro        *maestro.Maestro
}

func (this *FetchEntityStep) Act(ctx context.Context, in *maes.ShowGardenMaeIn, out *maes.ShowGardenMaeOut) (bool, error) {
	id := in.Request.Id
	entity, _, err := this.GardenFetcher.FindOneById(ctx, id, nil)
	if err != nil {
		return false, err
	}
	err = this.GardenHydrator.OneViaPreset(ctx, entity, "show", nil)
	if err != nil {
		return false, err
	}
	out.Response.Garden = entity
	return true, nil
}
