package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type SetupBreadcrumbStep struct {
	GardenFetcher *fetchers.GardenFetcher
	Maestro       *maestro.Maestro
}

func (this *SetupBreadcrumbStep) Act(ctx context.Context, in *maes.ShowGardenMaeIn, out *maes.ShowGardenMaeOut) (bool, error) {
	o1, _, err := this.GardenFetcher.FindOneById(ctx, out.In.Request.Id, this.GardenFetcher.Mod())
	if err != nil {
		return false, err
	}
	out.Extra.AddToScope("garden_id", o1.Id)
	out.Extra.Navigation.Breadcrumb.Items = append(out.Extra.Navigation.Breadcrumb.Items, o1)
	return true, nil
}
