package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/show_garden"
	"gardening/src/srv/fetchers"
)

type ShowGardenMae struct {
	AddGardenTasksToResponseStep *steps.AddGardenTasksToResponseStep
	AddPlantationsToResponseStep *steps.AddPlantationsToResponseStep
	AuthorizeStep                *steps.AuthorizeStep
	FetchEntityStep              *steps.FetchEntityStep
	FetchEventsStep              *steps.FetchEventsStep
	GardenTaskFetcher            *fetchers.GardenTaskFetcher
	Maestro                      *maestro.Maestro
	PlantationFetcher            *fetchers.PlantationFetcher
	SetupBreadcrumbStep          *steps.SetupBreadcrumbStep
}

func (this *ShowGardenMae) Act(ctx context.Context, in *maes.ShowGardenMaeIn) (*maes.ShowGardenMaeOut, error) {
	out := &maes.ShowGardenMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ShowGardenMaeIn, out *maes.ShowGardenMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.FetchEntityStep.Act,
		this.AddGardenTasksToResponseStep.Act,
		this.AddPlantationsToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
		this.FetchEventsStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
