package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type FetchEntityStep struct {
	GardenTaskFetcher  *fetchers.GardenTaskFetcher
	GardenTaskHydrator *hydrators.GardenTaskHydrator
	Maestro            *maestro.Maestro
}

func (this *FetchEntityStep) Act(ctx context.Context, in *maes.ShowGardenTaskMaeIn, out *maes.ShowGardenTaskMaeOut) (bool, error) {
	id := in.Request.Id
	entity, _, err := this.GardenTaskFetcher.FindOneById(ctx, id, nil)
	if err != nil {
		return false, err
	}
	err = this.GardenTaskHydrator.OneViaPreset(ctx, entity, "show", nil)
	if err != nil {
		return false, err
	}
	out.Response.GardenTask = entity
	return true, nil
}
