package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type SetupBreadcrumbStep struct {
	GardenTaskFetcher *fetchers.GardenTaskFetcher
	Maestro           *maestro.Maestro
}

func (this *SetupBreadcrumbStep) Act(ctx context.Context, in *maes.ShowGardenTaskMaeIn, out *maes.ShowGardenTaskMaeOut) (bool, error) {
	o1, _, err := this.GardenTaskFetcher.FindOneById(ctx, out.In.Request.Id, this.GardenTaskFetcher.Mod())
	if err != nil {
		return false, err
	}
	out.Extra.AddToScope("garden_task_id", o1.Id)
	out.Extra.Navigation.Breadcrumb.Items = append(out.Extra.Navigation.Breadcrumb.Items, o1)
	return true, nil
}
