package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/show_garden_task"
)

type ShowGardenTaskMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	FetchEntityStep     *steps.FetchEntityStep
	FetchEventsStep     *steps.FetchEventsStep
	Maestro             *maestro.Maestro
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *ShowGardenTaskMae) Act(ctx context.Context, in *maes.ShowGardenTaskMaeIn) (*maes.ShowGardenTaskMaeOut, error) {
	out := &maes.ShowGardenTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ShowGardenTaskMaeIn, out *maes.ShowGardenTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.FetchEntityStep.Act,
		this.SetupBreadcrumbStep.Act,
		this.FetchEventsStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
