package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type AddPlantTasksToResponseStep struct {
	Maestro           *maestro.Maestro
	PlantTaskFetcher  *fetchers.PlantTaskFetcher
	PlantTaskHydrator *hydrators.PlantTaskHydrator
}

func (this *AddPlantTasksToResponseStep) Act(ctx context.Context, in *maes.ShowPlantMaeIn, out *maes.ShowPlantMaeOut) (bool, error) {
	plantId := in.Request.Id
	mod := this.PlantTaskFetcher.Mod()
	mod.ExactStringValueFilter("plant_id", plantId)
	page, pagination, err := this.PlantTaskFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	out.Response.PlantTasks = page
	out.Response.PlantTasksPagination = pagination
	this.PlantTaskHydrator.ManyViaPreset(ctx, page, "list", nil)
	return true, nil
}
