package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type AddSeedProgramsToResponseStep struct {
	Maestro             *maestro.Maestro
	SeedProgramFetcher  *fetchers.SeedProgramFetcher
	SeedProgramHydrator *hydrators.SeedProgramHydrator
}

func (this *AddSeedProgramsToResponseStep) Act(ctx context.Context, in *maes.ShowPlantMaeIn, out *maes.ShowPlantMaeOut) (bool, error) {
	plantId := in.Request.Id
	mod := this.SeedProgramFetcher.Mod()
	mod.ExactStringValueFilter("plant_id", plantId)
	page, pagination, err := this.SeedProgramFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	out.Response.SeedPrograms = page
	out.Response.SeedProgramsPagination = pagination
	this.SeedProgramHydrator.ManyViaPreset(ctx, page, "list", nil)
	return true, nil
}
