package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type FetchEntityStep struct {
	Maestro       *maestro.Maestro
	PlantFetcher  *fetchers.PlantFetcher
	PlantHydrator *hydrators.PlantHydrator
}

func (this *FetchEntityStep) Act(ctx context.Context, in *maes.ShowPlantMaeIn, out *maes.ShowPlantMaeOut) (bool, error) {
	id := in.Request.Id
	entity, _, err := this.PlantFetcher.FindOneById(ctx, id, nil)
	if err != nil {
		return false, err
	}
	err = this.PlantHydrator.OneViaPreset(ctx, entity, "show", nil)
	if err != nil {
		return false, err
	}
	out.Response.Plant = entity
	return true, nil
}
