package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type FetchEventsStep struct {
	EventFetcher *fetchers.EventFetcher
	Maestro      *maestro.Maestro
}

func (this *FetchEventsStep) Act(ctx context.Context, in *maes.ShowPlantMaeIn, out *maes.ShowPlantMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.EventFetcher.Mod()
	mod.ExactStringValueFilter("resource_id", id)
	mod.ExactStringValueFilter("resource_type", "plant")
	set, err := this.EventFetcher.FindSet(ctx, mod)
	if err != nil {
		return false, err
	}
	out.Response.Events = set
	return true, nil
}
