package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type SetupBreadcrumbStep struct {
	Maestro      *maestro.Maestro
	PlantFetcher *fetchers.PlantFetcher
}

func (this *SetupBreadcrumbStep) Act(ctx context.Context, in *maes.ShowPlantMaeIn, out *maes.ShowPlantMaeOut) (bool, error) {
	o1, _, err := this.PlantFetcher.FindOneById(ctx, out.In.Request.Id, this.PlantFetcher.Mod())
	if err != nil {
		return false, err
	}
	out.Extra.AddToScope("plant_id", o1.Id)
	out.Extra.Navigation.Breadcrumb.Items = append(out.Extra.Navigation.Breadcrumb.Items, o1)
	return true, nil
}
