package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/show_plant"
	"gardening/src/srv/fetchers"
)

type ShowPlantMae struct {
	AddPlantTasksToResponseStep   *steps.AddPlantTasksToResponseStep
	AddPlantationsToResponseStep  *steps.AddPlantationsToResponseStep
	AddSeedProgramsToResponseStep *steps.AddSeedProgramsToResponseStep
	AuthorizeStep                 *steps.AuthorizeStep
	FetchEntityStep               *steps.FetchEntityStep
	FetchEventsStep               *steps.FetchEventsStep
	Maestro                       *maestro.Maestro
	PlantTaskFetcher              *fetchers.PlantTaskFetcher
	PlantationFetcher             *fetchers.PlantationFetcher
	SeedProgramFetcher            *fetchers.SeedProgramFetcher
	SetupBreadcrumbStep           *steps.SetupBreadcrumbStep
}

func (this *ShowPlantMae) Act(ctx context.Context, in *maes.ShowPlantMaeIn) (*maes.ShowPlantMaeOut, error) {
	out := &maes.ShowPlantMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ShowPlantMaeIn, out *maes.ShowPlantMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.FetchEntityStep.Act,
		this.AddPlantTasksToResponseStep.Act,
		this.AddPlantationsToResponseStep.Act,
		this.AddSeedProgramsToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
		this.FetchEventsStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
