package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type FetchEntityStep struct {
	Maestro           *maestro.Maestro
	PlantTaskFetcher  *fetchers.PlantTaskFetcher
	PlantTaskHydrator *hydrators.PlantTaskHydrator
}

func (this *FetchEntityStep) Act(ctx context.Context, in *maes.ShowPlantTaskMaeIn, out *maes.ShowPlantTaskMaeOut) (bool, error) {
	id := in.Request.Id
	entity, _, err := this.PlantTaskFetcher.FindOneById(ctx, id, nil)
	if err != nil {
		return false, err
	}
	err = this.PlantTaskHydrator.OneViaPreset(ctx, entity, "show", nil)
	if err != nil {
		return false, err
	}
	out.Response.PlantTask = entity
	return true, nil
}
