package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type FetchEventsStep struct {
	EventFetcher *fetchers.EventFetcher
	Maestro      *maestro.Maestro
}

func (this *FetchEventsStep) Act(ctx context.Context, in *maes.ShowPlantTaskMaeIn, out *maes.ShowPlantTaskMaeOut) (bool, error) {
	id := in.Request.Id
	mod := this.EventFetcher.Mod()
	mod.ExactStringValueFilter("resource_id", id)
	mod.ExactStringValueFilter("resource_type", "plant_task")
	set, err := this.EventFetcher.FindSet(ctx, mod)
	if err != nil {
		return false, err
	}
	out.Response.Events = set
	return true, nil
}
