package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type SetupBreadcrumbStep struct {
	Maestro          *maestro.Maestro
	PlantTaskFetcher *fetchers.PlantTaskFetcher
}

func (this *SetupBreadcrumbStep) Act(ctx context.Context, in *maes.ShowPlantTaskMaeIn, out *maes.ShowPlantTaskMaeOut) (bool, error) {
	o1, _, err := this.PlantTaskFetcher.FindOneById(ctx, out.In.Request.Id, this.PlantTaskFetcher.Mod())
	if err != nil {
		return false, err
	}
	out.Extra.AddToScope("plant_task_id", o1.Id)
	out.Extra.Navigation.Breadcrumb.Items = append(out.Extra.Navigation.Breadcrumb.Items, o1)
	return true, nil
}
