package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/show_plant_task"
)

type ShowPlantTaskMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	FetchEntityStep     *steps.FetchEntityStep
	FetchEventsStep     *steps.FetchEventsStep
	Maestro             *maestro.Maestro
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *ShowPlantTaskMae) Act(ctx context.Context, in *maes.ShowPlantTaskMaeIn) (*maes.ShowPlantTaskMaeOut, error) {
	out := &maes.ShowPlantTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ShowPlantTaskMaeIn, out *maes.ShowPlantTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.FetchEntityStep.Act,
		this.SetupBreadcrumbStep.Act,
		this.FetchEventsStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
