package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type FetchEntityStep struct {
	Maestro            *maestro.Maestro
	PlantationFetcher  *fetchers.PlantationFetcher
	PlantationHydrator *hydrators.PlantationHydrator
}

func (this *FetchEntityStep) Act(ctx context.Context, in *maes.ShowPlantationMaeIn, out *maes.ShowPlantationMaeOut) (bool, error) {
	id := in.Request.Id
	entity, _, err := this.PlantationFetcher.FindOneById(ctx, id, nil)
	if err != nil {
		return false, err
	}
	err = this.PlantationHydrator.OneViaPreset(ctx, entity, "show", nil)
	if err != nil {
		return false, err
	}
	out.Response.Plantation = entity
	return true, nil
}
