package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/show_plantation"
	"gardening/src/srv/fetchers"
)

type ShowPlantationMae struct {
	AddGardenTasksToResponseStep *steps.AddGardenTasksToResponseStep
	AuthorizeStep                *steps.AuthorizeStep
	FetchEntityStep              *steps.FetchEntityStep
	FetchEventsStep              *steps.FetchEventsStep
	GardenTaskFetcher            *fetchers.GardenTaskFetcher
	Maestro                      *maestro.Maestro
	SetupBreadcrumbStep          *steps.SetupBreadcrumbStep
}

func (this *ShowPlantationMae) Act(ctx context.Context, in *maes.ShowPlantationMaeIn) (*maes.ShowPlantationMaeOut, error) {
	out := &maes.ShowPlantationMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ShowPlantationMaeIn, out *maes.ShowPlantationMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.FetchEntityStep.Act,
		this.AddGardenTasksToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
		this.FetchEventsStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
