package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type FetchEntityStep struct {
	Maestro             *maestro.Maestro
	SeedProgramFetcher  *fetchers.SeedProgramFetcher
	SeedProgramHydrator *hydrators.SeedProgramHydrator
}

func (this *FetchEntityStep) Act(ctx context.Context, in *maes.ShowSeedProgramMaeIn, out *maes.ShowSeedProgramMaeOut) (bool, error) {
	id := in.Request.Id
	entity, _, err := this.SeedProgramFetcher.FindOneById(ctx, id, nil)
	if err != nil {
		return false, err
	}
	err = this.SeedProgramHydrator.OneViaPreset(ctx, entity, "show", nil)
	if err != nil {
		return false, err
	}
	out.Response.SeedProgram = entity
	return true, nil
}
