package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type SetupBreadcrumbStep struct {
	Maestro            *maestro.Maestro
	SeedProgramFetcher *fetchers.SeedProgramFetcher
}

func (this *SetupBreadcrumbStep) Act(ctx context.Context, in *maes.ShowSeedProgramMaeIn, out *maes.ShowSeedProgramMaeOut) (bool, error) {
	o1, _, err := this.SeedProgramFetcher.FindOneById(ctx, out.In.Request.Id, this.SeedProgramFetcher.Mod())
	if err != nil {
		return false, err
	}
	out.Extra.AddToScope("seed_program_id", o1.Id)
	out.Extra.Navigation.Breadcrumb.Items = append(out.Extra.Navigation.Breadcrumb.Items, o1)
	return true, nil
}
