package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
)

type FetchEntityStep struct {
	Maestro      *maestro.Maestro
	UserFetcher  *fetchers.UserFetcher
	UserHydrator *hydrators.UserHydrator
}

func (this *FetchEntityStep) Act(ctx context.Context, in *maes.ShowUserMaeIn, out *maes.ShowUserMaeOut) (bool, error) {
	id := in.Request.Id
	entity, _, err := this.UserFetcher.FindOneById(ctx, id, nil)
	if err != nil {
		return false, err
	}
	err = this.UserHydrator.OneViaPreset(ctx, entity, "show", nil)
	if err != nil {
		return false, err
	}
	out.Response.User = entity
	return true, nil
}
