package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type SetupBreadcrumbStep struct {
	Maestro     *maestro.Maestro
	UserFetcher *fetchers.UserFetcher
}

func (this *SetupBreadcrumbStep) Act(ctx context.Context, in *maes.ShowUserMaeIn, out *maes.ShowUserMaeOut) (bool, error) {
	o1, _, err := this.UserFetcher.FindOneById(ctx, out.In.Request.Id, this.UserFetcher.Mod())
	if err != nil {
		return false, err
	}
	out.Extra.AddToScope("user_id", o1.Id)
	out.Extra.Navigation.Breadcrumb.Items = append(out.Extra.Navigation.Breadcrumb.Items, o1)
	return true, nil
}
