package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/show_user"
)

type ShowUserMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	FetchEntityStep     *steps.FetchEntityStep
	FetchEventsStep     *steps.FetchEventsStep
	Maestro             *maestro.Maestro
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *ShowUserMae) Act(ctx context.Context, in *maes.ShowUserMaeIn) (*maes.ShowUserMaeOut, error) {
	out := &maes.ShowUserMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ShowUserMaeIn, out *maes.ShowUserMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.FetchEntityStep.Act,
		this.SetupBreadcrumbStep.Act,
		this.FetchEventsStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
