package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/handlers"
)

type RecordEventStep struct {
	EventHandler *handlers.EventHandler
	Maestro      *maestro.Maestro
}

func (this *RecordEventStep) Act(ctx context.Context, in *maes.UpdateGardenMaeIn, out *maes.UpdateGardenMaeOut) (bool, error) {
	event := this.Maestro.NewEvent(ctx)
	event.What = "update_garden"
	event.ResourceId = out.Response.Garden.Id
	event.ResourceType = "garden"
	this.EventHandler.MustCreate(ctx, event, nil)
	return true, nil
}
