package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/update_garden"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type UpdateGardenMae struct {
	AuthorizeStep             *steps.AuthorizeStep
	GardenHandler             *handlers.GardenHandler
	Maestro                   *maestro.Maestro
	RecordEventStep           *steps.RecordEventStep
	SaveEntityStep            *steps.SaveEntityStep
	SqlDb                     *sql_db.SqlDb
	UpdateGardenFormMolder    *molders.UpdateGardenFormMolder
	UpdateGardenFormValidator *form_validators.UpdateGardenFormValidator
	ValidateFormStep          *steps.ValidateFormStep
}

func (this *UpdateGardenMae) Act(ctx context.Context, in *maes.UpdateGardenMaeIn) (*maes.UpdateGardenMaeOut, error) {
	out := &maes.UpdateGardenMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.UpdateGardenMaeIn, out *maes.UpdateGardenMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
