package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/handlers"
)

type RecordEventStep struct {
	EventHandler *handlers.EventHandler
	Maestro      *maestro.Maestro
}

func (this *RecordEventStep) Act(ctx context.Context, in *maes.UpdateGardenTaskMaeIn, out *maes.UpdateGardenTaskMaeOut) (bool, error) {
	event := this.Maestro.NewEvent(ctx)
	event.What = "update_garden_task"
	event.ResourceId = out.Response.GardenTask.Id
	event.ResourceType = "garden_task"
	this.EventHandler.MustCreate(ctx, event, nil)
	return true, nil
}
