package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/update_garden_task"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type UpdateGardenTaskMae struct {
	AuthorizeStep                 *steps.AuthorizeStep
	GardenTaskHandler             *handlers.GardenTaskHandler
	Maestro                       *maestro.Maestro
	RecordEventStep               *steps.RecordEventStep
	SaveEntityStep                *steps.SaveEntityStep
	SqlDb                         *sql_db.SqlDb
	UpdateGardenTaskFormMolder    *molders.UpdateGardenTaskFormMolder
	UpdateGardenTaskFormValidator *form_validators.UpdateGardenTaskFormValidator
	ValidateFormStep              *steps.ValidateFormStep
}

func (this *UpdateGardenTaskMae) Act(ctx context.Context, in *maes.UpdateGardenTaskMaeIn) (*maes.UpdateGardenTaskMaeOut, error) {
	out := &maes.UpdateGardenTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.UpdateGardenTaskMaeIn, out *maes.UpdateGardenTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
