package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/handlers"
)

type RecordEventStep struct {
	EventHandler *handlers.EventHandler
	Maestro      *maestro.Maestro
}

func (this *RecordEventStep) Act(ctx context.Context, in *maes.UpdatePlantMaeIn, out *maes.UpdatePlantMaeOut) (bool, error) {
	event := this.Maestro.NewEvent(ctx)
	event.What = "update_plant"
	event.ResourceId = out.Response.Plant.Id
	event.ResourceType = "plant"
	this.EventHandler.MustCreate(ctx, event, nil)
	return true, nil
}
