package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	Maestro               *maestro.Maestro
	PlantFetcher          *fetchers.PlantFetcher
	PlantHandler          *handlers.PlantHandler
	UpdatePlantFormMolder *molders.UpdatePlantFormMolder
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.UpdatePlantMaeIn, out *maes.UpdatePlantMaeOut) (bool, error) {
	var err error
	entity, has, err := this.PlantFetcher.FindOneById(ctx, in.Request.Form.Id, nil)
	if err != nil {
		return false, err
	}
	if !has {
		return false, erro.N("No entity found")
	}
	entity, fields := this.UpdatePlantFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.Plant, err = this.PlantHandler.UpdateFields(ctx, entity, fields, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Plant updated")
	return true, nil
}
