package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/update_plant"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type UpdatePlantMae struct {
	AuthorizeStep            *steps.AuthorizeStep
	Maestro                  *maestro.Maestro
	PlantHandler             *handlers.PlantHandler
	RecordEventStep          *steps.RecordEventStep
	SaveEntityStep           *steps.SaveEntityStep
	SqlDb                    *sql_db.SqlDb
	UpdatePlantFormMolder    *molders.UpdatePlantFormMolder
	UpdatePlantFormValidator *form_validators.UpdatePlantFormValidator
	ValidateFormStep         *steps.ValidateFormStep
}

func (this *UpdatePlantMae) Act(ctx context.Context, in *maes.UpdatePlantMaeIn) (*maes.UpdatePlantMaeOut, error) {
	out := &maes.UpdatePlantMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.UpdatePlantMaeIn, out *maes.UpdatePlantMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
