package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/handlers"
)

type RecordEventStep struct {
	EventHandler *handlers.EventHandler
	Maestro      *maestro.Maestro
}

func (this *RecordEventStep) Act(ctx context.Context, in *maes.UpdatePlantTaskMaeIn, out *maes.UpdatePlantTaskMaeOut) (bool, error) {
	event := this.Maestro.NewEvent(ctx)
	event.What = "update_plant_task"
	event.ResourceId = out.Response.PlantTask.Id
	event.ResourceType = "plant_task"
	this.EventHandler.MustCreate(ctx, event, nil)
	return true, nil
}
