package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	Maestro                      *maestro.Maestro
	UpdatePlantTaskFormValidator *form_validators.UpdatePlantTaskFormValidator
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.UpdatePlantTaskMaeIn, out *maes.UpdatePlantTaskMaeOut) (bool, error) {
	bag, err := this.UpdatePlantTaskFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
