package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/update_plant_task"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type UpdatePlantTaskMae struct {
	AuthorizeStep                *steps.AuthorizeStep
	Maestro                      *maestro.Maestro
	PlantTaskHandler             *handlers.PlantTaskHandler
	RecordEventStep              *steps.RecordEventStep
	SaveEntityStep               *steps.SaveEntityStep
	SqlDb                        *sql_db.SqlDb
	UpdatePlantTaskFormMolder    *molders.UpdatePlantTaskFormMolder
	UpdatePlantTaskFormValidator *form_validators.UpdatePlantTaskFormValidator
	ValidateFormStep             *steps.ValidateFormStep
}

func (this *UpdatePlantTaskMae) Act(ctx context.Context, in *maes.UpdatePlantTaskMaeIn) (*maes.UpdatePlantTaskMaeOut, error) {
	out := &maes.UpdatePlantTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.UpdatePlantTaskMaeIn, out *maes.UpdatePlantTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
