package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	Maestro                    *maestro.Maestro
	PlantationFetcher          *fetchers.PlantationFetcher
	PlantationHandler          *handlers.PlantationHandler
	UpdatePlantationFormMolder *molders.UpdatePlantationFormMolder
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.UpdatePlantationMaeIn, out *maes.UpdatePlantationMaeOut) (bool, error) {
	var err error
	entity, has, err := this.PlantationFetcher.FindOneById(ctx, in.Request.Form.Id, nil)
	if err != nil {
		return false, err
	}
	if !has {
		return false, erro.N("No entity found")
	}
	entity, fields := this.UpdatePlantationFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.Plantation, err = this.PlantationHandler.UpdateFields(ctx, entity, fields, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Plantation updated")
	return true, nil
}
