package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	Maestro                       *maestro.Maestro
	UpdatePlantationFormValidator *form_validators.UpdatePlantationFormValidator
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.UpdatePlantationMaeIn, out *maes.UpdatePlantationMaeOut) (bool, error) {
	bag, err := this.UpdatePlantationFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
