package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/update_plantation"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type UpdatePlantationMae struct {
	AuthorizeStep                 *steps.AuthorizeStep
	Maestro                       *maestro.Maestro
	PlantationHandler             *handlers.PlantationHandler
	RecordEventStep               *steps.RecordEventStep
	SaveEntityStep                *steps.SaveEntityStep
	SqlDb                         *sql_db.SqlDb
	UpdatePlantationFormMolder    *molders.UpdatePlantationFormMolder
	UpdatePlantationFormValidator *form_validators.UpdatePlantationFormValidator
	ValidateFormStep              *steps.ValidateFormStep
}

func (this *UpdatePlantationMae) Act(ctx context.Context, in *maes.UpdatePlantationMaeIn) (*maes.UpdatePlantationMaeOut, error) {
	out := &maes.UpdatePlantationMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.UpdatePlantationMaeIn, out *maes.UpdatePlantationMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
