package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type SaveEntityStep struct {
	Maestro                     *maestro.Maestro
	SeedProgramFetcher          *fetchers.SeedProgramFetcher
	SeedProgramHandler          *handlers.SeedProgramHandler
	UpdateSeedProgramFormMolder *molders.UpdateSeedProgramFormMolder
}

func (this *SaveEntityStep) Act(ctx context.Context, in *maes.UpdateSeedProgramMaeIn, out *maes.UpdateSeedProgramMaeOut) (bool, error) {
	var err error
	entity, has, err := this.SeedProgramFetcher.FindOneById(ctx, in.Request.Form.Id, nil)
	if err != nil {
		return false, err
	}
	if !has {
		return false, erro.N("No entity found")
	}
	entity, fields := this.UpdateSeedProgramFormMolder.ToEntity(&in.Request.Form, entity)
	out.Response.SeedProgram, err = this.SeedProgramHandler.UpdateFields(ctx, entity, fields, nil)
	if err != nil {
		return false, err
	}
	this.Maestro.AddSuccessMessage(&out.Extra, "Seed Program updated")
	return true, nil
}
