package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	Maestro                        *maestro.Maestro
	UpdateSeedProgramFormValidator *form_validators.UpdateSeedProgramFormValidator
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.UpdateSeedProgramMaeIn, out *maes.UpdateSeedProgramMaeOut) (bool, error) {
	bag, err := this.UpdateSeedProgramFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
