package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/update_seed_program"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type UpdateSeedProgramMae struct {
	AuthorizeStep                  *steps.AuthorizeStep
	Maestro                        *maestro.Maestro
	RecordEventStep                *steps.RecordEventStep
	SaveEntityStep                 *steps.SaveEntityStep
	SeedProgramHandler             *handlers.SeedProgramHandler
	SqlDb                          *sql_db.SqlDb
	UpdateSeedProgramFormMolder    *molders.UpdateSeedProgramFormMolder
	UpdateSeedProgramFormValidator *form_validators.UpdateSeedProgramFormValidator
	ValidateFormStep               *steps.ValidateFormStep
}

func (this *UpdateSeedProgramMae) Act(ctx context.Context, in *maes.UpdateSeedProgramMaeIn) (*maes.UpdateSeedProgramMaeOut, error) {
	out := &maes.UpdateSeedProgramMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.UpdateSeedProgramMaeIn, out *maes.UpdateSeedProgramMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
