package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/lib/sql_db"
	"gardening/src/mae/update_user"
	"gardening/src/srv/form_validators"
	"gardening/src/srv/handlers"
	"gardening/src/srv/molders"
)

type UpdateUserMae struct {
	AuthorizeStep           *steps.AuthorizeStep
	Maestro                 *maestro.Maestro
	RecordEventStep         *steps.RecordEventStep
	SaveEntityStep          *steps.SaveEntityStep
	SqlDb                   *sql_db.SqlDb
	UpdateUserFormMolder    *molders.UpdateUserFormMolder
	UpdateUserFormValidator *form_validators.UpdateUserFormValidator
	UserHandler             *handlers.UserHandler
	ValidateFormStep        *steps.ValidateFormStep
}

func (this *UpdateUserMae) Act(ctx context.Context, in *maes.UpdateUserMaeIn) (*maes.UpdateUserMaeOut, error) {
	out := &maes.UpdateUserMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.UpdateUserMaeIn, out *maes.UpdateUserMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ValidateFormStep.Act,
		this.SaveEntityStep.Act,
		this.RecordEventStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
