package mdl

import (
	"time"
)

type Plant struct {
	Id             string
	CreatedAt      time.Time
	UpdatedAt      time.Time
	Data           []byte
	Description    string
	Exposition     string
	Harvested      float64
	Name           string
	Perennial      bool
	PlantingSchema PlantingSchema
	Reference      string
	Size           int
	PlantTasks     []*PlantTask
	Plantations    []*Plantation
	SeedPrograms   []*SeedProgram
}

type PlantingSchema struct {
}

func (this *Plant) AppendPlantTask(plantTask *PlantTask) {
	this.PlantTasks = append(this.PlantTasks, plantTask)
}
func (this *Plant) AppendPlantation(plantation *Plantation) {
	this.Plantations = append(this.Plantations, plantation)
}
func (this *Plant) AppendSeedProgram(seedProgram *SeedProgram) {
	this.SeedPrograms = append(this.SeedPrograms, seedProgram)
}
func (this *Plant) GetId() string {
	return this.Id
}
