package autocompleters

// |@@| C

import (
	"context"
	"gardening/src/lib/completer"
	"gardening/src/srv/completers"
)

type Autocompleter struct {
	GardenCompleter      *completers.GardenCompleter
	GardenTaskCompleter  *completers.GardenTaskCompleter
	PlantCompleter       *completers.PlantCompleter
	PlantTaskCompleter   *completers.PlantTaskCompleter
	PlantationCompleter  *completers.PlantationCompleter
	SeedProgramCompleter *completers.SeedProgramCompleter
	UserCompleter        *completers.UserCompleter
}

func (this *Autocompleter) NewRequest() *completer.AutocompleteRequest {
	return &completer.AutocompleteRequest{}
}
func (this *Autocompleter) Provide(ctx context.Context, request *completer.AutocompleteRequest) ([]*completer.Item, error) {
	key := request.Key
	if key == "gardens" {
		return this.GardenCompleter.Provide(ctx, request)
	}
	if key == "garden_tasks" {
		return this.GardenTaskCompleter.Provide(ctx, request)
	}
	if key == "plants" {
		return this.PlantCompleter.Provide(ctx, request)
	}
	if key == "plant_tasks" {
		return this.PlantTaskCompleter.Provide(ctx, request)
	}
	if key == "plantations" {
		return this.PlantationCompleter.Provide(ctx, request)
	}
	if key == "seed_programs" {
		return this.SeedProgramCompleter.Provide(ctx, request)
	}
	if key == "users" {
		return this.UserCompleter.Provide(ctx, request)
	}
	return nil, nil
}
