package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type CreateGardenAppBinder struct {
	Binder *binder.Binder
}

func (this *CreateGardenAppBinder) Bind(ctx context.Context, in *maes.CreateGardenMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *CreateGardenAppBinder) bindRequestForm(ctx context.Context, in *maes.CreateGardenMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.Picture = this.Binder.PostFormStringField("form[picture]", c, &in.Context)
	return nil
}
func (this *CreateGardenAppBinder) bindRequestFiles(ctx context.Context, in *maes.CreateGardenMaeIn, c *gin.Context) error {
	s := &in.Request.Files
	s.Picture = this.Binder.PostFormStringField("files[picture]", c, &in.Context)
	return nil
}
func (this *CreateGardenAppBinder) bindRequest(ctx context.Context, in *maes.CreateGardenMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	this.bindRequestFiles(ctx, in, c)
	return nil
}
