package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type CreateGardenTaskAppBinder struct {
	Binder *binder.Binder
}

func (this *CreateGardenTaskAppBinder) Bind(ctx context.Context, in *maes.CreateGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *CreateGardenTaskAppBinder) bindRequestForm(ctx context.Context, in *maes.CreateGardenTaskMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Description = this.Binder.PostFormStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.StartDate = this.Binder.PostFormTimeField("form[start_date]", c, &in.Context)
	s.GardenId = this.Binder.PostFormStringField("form[garden_id]", c, &in.Context)
	s.PlantationId = this.Binder.PostFormStringField("form[plantation_id]", c, &in.Context)
	return nil
}
func (this *CreateGardenTaskAppBinder) bindRequest(ctx context.Context, in *maes.CreateGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
